/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.decorative;

import com.ldtteam.structurize.blocks.types.ShingleFaceType;
import com.ldtteam.structurize.blocks.types.WoodType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.DyeColor;
import net.minecraft.state.properties.StairsShape;

public class BlockShingle
extends StairsBlock {
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private final WoodType woodType;
    private final ShingleFaceType faceType;
    private final DyeColor color;

    public BlockShingle(Supplier<BlockState> modelState, WoodType woodType, ShingleFaceType faceType, DyeColor color) {
        super(modelState, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 1.0f).func_226896_b_());
        this.woodType = woodType;
        this.faceType = faceType;
        this.color = color;
    }

    public static String getTypeFromShape(StairsShape shape) {
        switch (shape) {
            case INNER_LEFT: 
            case INNER_RIGHT: {
                return "concave";
            }
            case OUTER_LEFT: 
            case OUTER_RIGHT: {
                return "convex";
            }
        }
        return "straight";
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public ShingleFaceType getFaceType() {
        return this.faceType;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public String getTypeString() {
        return (this.getColor() == null ? "" : this.getColor().func_176610_l() + "_") + this.getFaceType().getGroup();
    }
}

